<?php
require_once '../config.php';

if(!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please login first']);
    exit();
}

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['transaction_id'])) {
    $transaction_id = (int)$_POST['transaction_id'];
    $user_id = $_SESSION['user_id'];
    
    // Get transaction details
    $stmt = $conn->prepare("SELECT * FROM transactions WHERE id = ? AND user_id = ? AND type = 'deposit' AND status = 'pending'");
    $stmt->bind_param("ii", $transaction_id, $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Transaction not found or cannot be cancelled']);
        exit();
    }
    
    $transaction = $result->fetch_assoc();
    
    // Update transaction status
    $update_stmt = $conn->prepare("UPDATE transactions SET status = 'failed', description = CONCAT(description, ' - Cancelled by user') WHERE id = ?");
    $update_stmt->bind_param("i", $transaction_id);
    
    if($update_stmt->execute()) {
        // Send notification to admin
        $admin_notification = "Deposit transaction #$transaction_id cancelled by user ID $user_id";
        $conn->query("INSERT INTO admin_notifications (message, type) VALUES ('$admin_notification', 'deposit_cancelled')");
        
        echo json_encode(['success' => true, 'message' => 'Transaction cancelled successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to cancel transaction']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>